/*
 * Decompiled with CFR 0.152.
 */
package com.filemaker.jdbc;

import com.filemaker.jdbc.FMStream;
import com.filemaker.jdbc.MessageBlock;
import com.filemaker.jdbc.MessageBlockBytes;
import java.util.ArrayList;
import java.util.Vector;

public class ProtocolMessage {
    protected short blockType;
    protected ArrayList messageBlocks;
    protected int currentBlock;
    protected boolean extracted;

    public ProtocolMessage(short s) {
        this.blockType = s;
        this.extracted = false;
        this.currentBlock = 0;
        this.messageBlocks = new ArrayList();
        this.messageBlocks.add(new MessageBlock(0, s));
    }

    public ProtocolMessage(byte[] byArray) {
        this.extracted = false;
        this.currentBlock = 0;
        this.messageBlocks = new ArrayList();
        this.messageBlocks.add(new MessageBlock(byArray));
        MessageBlock messageBlock = (MessageBlock)this.messageBlocks.get(0);
        this.blockType = messageBlock.getBlockType();
    }

    public ProtocolMessage(MessageBlock messageBlock) {
        this.extracted = false;
        this.currentBlock = 0;
        this.messageBlocks = new ArrayList();
        this.messageBlocks.add(messageBlock);
        MessageBlock messageBlock2 = (MessageBlock)this.messageBlocks.get(0);
        this.blockType = messageBlock2.getBlockType();
    }

    public boolean append(int n, byte[] byArray) {
        this.messageBlocks.add(new MessageBlock(byArray));
        return true;
    }

    public boolean extract() {
        return false;
    }

    public short getParameter8() {
        boolean bl = true;
        MessageBlock messageBlock = (MessageBlock)this.messageBlocks.get(this.currentBlock);
        short s = messageBlock.getParameter8();
        if (s < 0) {
            bl = false;
        }
        if (!bl) {
            ++this.currentBlock;
            if (this.currentBlock < this.messageBlocks.size()) {
                messageBlock = (MessageBlock)this.messageBlocks.get(this.currentBlock);
                s = messageBlock.getParameter8();
            }
        }
        return s;
    }

    public int getParameter16() {
        boolean bl = true;
        MessageBlock messageBlock = (MessageBlock)this.messageBlocks.get(this.currentBlock);
        int n = messageBlock.getParameter16();
        if (n < 0) {
            bl = false;
        }
        if (!bl) {
            ++this.currentBlock;
            if (this.currentBlock < this.messageBlocks.size()) {
                messageBlock = (MessageBlock)this.messageBlocks.get(this.currentBlock);
                n = messageBlock.getParameter16();
            }
        }
        return n;
    }

    public long getParameter32() {
        boolean bl = true;
        MessageBlock messageBlock = (MessageBlock)this.messageBlocks.get(this.currentBlock);
        long l = messageBlock.getParameter32();
        if (l < 0L) {
            bl = false;
        }
        if (!bl) {
            ++this.currentBlock;
            if (this.currentBlock < this.messageBlocks.size()) {
                messageBlock = (MessageBlock)this.messageBlocks.get(this.currentBlock);
                l = messageBlock.getParameter32();
            }
        }
        return l;
    }

    public long getParameter64() {
        boolean bl = true;
        MessageBlock messageBlock = (MessageBlock)this.messageBlocks.get(this.currentBlock);
        long l = messageBlock.getParameter64();
        if (l < 0L) {
            bl = false;
        }
        if (!bl) {
            ++this.currentBlock;
            if (this.currentBlock < this.messageBlocks.size()) {
                messageBlock = (MessageBlock)this.messageBlocks.get(this.currentBlock);
                l = messageBlock.getParameter64();
            }
        }
        return l;
    }

    public String getParameter() {
        boolean bl = true;
        MessageBlock messageBlock = (MessageBlock)this.messageBlocks.get(this.currentBlock);
        String string = messageBlock.getParameter();
        long l = messageBlock.getStringBytesRemaining();
        if (l > 0L) {
            bl = false;
        }
        while (!bl) {
            ++this.currentBlock;
            if (this.currentBlock < this.messageBlocks.size()) {
                messageBlock = (MessageBlock)this.messageBlocks.get(this.currentBlock);
                String string2 = messageBlock.getParameter();
                l = messageBlock.getStringBytesRemaining();
                string = string + string2;
                if (l > 0L) continue;
                bl = true;
                continue;
            }
            bl = true;
        }
        return string;
    }

    public boolean getParameter(byte[] byArray) {
        boolean bl = true;
        long l = byArray.length;
        MessageBlock messageBlock = (MessageBlock)this.messageBlocks.get(this.currentBlock);
        long l2 = messageBlock.getParameter(byArray, 0L);
        if (l2 > 0L) {
            bl = false;
        }
        while (!bl) {
            long l3 = l - l2;
            ++this.currentBlock;
            if (this.currentBlock < this.messageBlocks.size()) {
                messageBlock = (MessageBlock)this.messageBlocks.get(this.currentBlock);
                l2 = messageBlock.getParameter(byArray, l3);
                if (l2 > 0L) continue;
                bl = true;
                continue;
            }
            bl = true;
        }
        return bl;
    }

    public int getParameterAsList(long l, Vector vector) {
        byte[] byArray = new byte[65535];
        boolean bl = false;
        long l2 = l;
        MessageBlock messageBlock = (MessageBlock)this.messageBlocks.get(this.currentBlock);
        long l3 = messageBlock.getParameter(byArray, 0L);
        while (!bl) {
            long l4 = l2 - l3;
            l2 -= l4;
            boolean bl2 = false;
            if (!bl2) {
                byte[] byArray2 = new byte[(int)l4];
                System.arraycopy(byArray, 0, byArray2, 0, (int)l4);
                vector.addElement(byArray2);
            } else {
                vector.addElement(messageBlock);
            }
            if (l3 <= 0L) {
                bl = true;
            }
            if (!bl && this.currentBlock < this.messageBlocks.size()) {
                ++this.currentBlock;
                messageBlock = (MessageBlock)this.messageBlocks.get(this.currentBlock);
                l3 = messageBlock.getParameter(byArray, 0L);
                continue;
            }
            bl = true;
        }
        return messageBlock.byteIndex;
    }

    public boolean addParameter(byte[] byArray) {
        return this.addParameter(byArray, byArray.length);
    }

    public boolean addParameter(byte[] byArray, long l) {
        boolean bl = true;
        MessageBlock messageBlock = (MessageBlock)this.messageBlocks.get(this.currentBlock);
        long l2 = messageBlock.addParameter(byArray, 0L, l);
        if (l2 > 0L) {
            bl = false;
        }
        while (!bl) {
            long l3 = l - l2;
            ++this.currentBlock;
            messageBlock = new MessageBlock(this.currentBlock, this.blockType);
            this.messageBlocks.add(messageBlock);
            l2 = messageBlock.addParameter(byArray, l3, l);
            if (l2 > 0L) continue;
            bl = true;
        }
        return bl;
    }

    public boolean addParameter8(short s) {
        MessageBlock messageBlock = (MessageBlock)this.messageBlocks.get(this.currentBlock);
        boolean bl = messageBlock.addParameter8(s);
        if (!bl) {
            ++this.currentBlock;
            messageBlock = new MessageBlock(this.currentBlock, this.blockType);
            this.messageBlocks.add(messageBlock);
            bl = messageBlock.addParameter8(s);
        }
        return bl;
    }

    public boolean addParameter16(int n) {
        MessageBlock messageBlock = (MessageBlock)this.messageBlocks.get(this.currentBlock);
        boolean bl = messageBlock.addParameter16(n);
        if (!bl) {
            ++this.currentBlock;
            messageBlock = new MessageBlock(this.currentBlock, this.blockType);
            this.messageBlocks.add(messageBlock);
            bl = messageBlock.addParameter16(n);
        }
        return bl;
    }

    public boolean addParameter32(long l) {
        MessageBlock messageBlock = (MessageBlock)this.messageBlocks.get(this.currentBlock);
        boolean bl = messageBlock.addParameter32(l);
        if (!bl) {
            ++this.currentBlock;
            messageBlock = new MessageBlock(this.currentBlock, this.blockType);
            this.messageBlocks.add(messageBlock);
            bl = messageBlock.addParameter32(l);
        }
        return bl;
    }

    public boolean addParameter64(long l) {
        MessageBlock messageBlock = (MessageBlock)this.messageBlocks.get(this.currentBlock);
        boolean bl = messageBlock.addParameter64(l);
        if (!bl) {
            ++this.currentBlock;
            messageBlock = new MessageBlock(this.currentBlock, this.blockType);
            this.messageBlocks.add(messageBlock);
            bl = messageBlock.addParameter64(l);
        }
        return bl;
    }

    public boolean addParameter(String string) {
        try {
            return this.addParameter(string.getBytes("UTF-8"));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public synchronized boolean send(FMStream fMStream) {
        boolean bl = true;
        for (int i = 0; bl && i < this.messageBlocks.size(); ++i) {
            boolean bl2 = i == this.messageBlocks.size() - 1;
            MessageBlock messageBlock = (MessageBlock)this.messageBlocks.get(i);
            bl = messageBlock.send(fMStream, bl2);
        }
        return bl;
    }

    public static synchronized MessageBlockBytes getBlock(FMStream fMStream) throws Exception {
        return MessageBlock.getBlock(fMStream);
    }
}

