/*
 * Decompiled with CFR 0.152.
 */
package com.filemaker.jdbc1;

import com.filemaker.jdbc.BaseConnection;
import com.filemaker.jdbc.BaseResultSet;
import com.filemaker.jdbc.BaseStatement;
import com.filemaker.jdbc.Driver;
import com.filemaker.jdbc.Encoding;
import com.filemaker.jdbc.FMColumnValue;
import com.filemaker.jdbc.FMSQLException;
import com.filemaker.jdbc.FM_API;
import com.filemaker.jdbc.Field;
import com.filemaker.jdbc1.FMInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Vector;

public abstract class CommonJ1ResultSet
implements BaseResultSet {
    protected boolean hasFetched = false;
    protected Vector rows;
    protected BaseStatement statement;
    protected Field[] fields;
    protected String status;
    protected boolean binaryCursor = false;
    protected int updateCount;
    protected long insertType;
    protected int current_row;
    protected int totalRowsFetched = 0;
    protected FMColumnValue[] this_row;
    protected BaseConnection connection;
    protected SQLWarning warnings = null;
    protected boolean wasNullFlag = false;
    protected int commandID = -1;
    protected int resultSetType = 1003;
    protected byte[][] savedRow;
    protected BaseResultSet next = null;
    private StringBuffer sbuf = null;
    public byte[][] rowBuffer = null;
    private SimpleDateFormat m_tsFormat = null;
    private SimpleDateFormat m_tstzFormat = null;
    private SimpleDateFormat m_dateFormat = null;
    private int fetchSize = 0;
    private int lastFetchSize = 0;

    @Override
    public abstract ResultSetMetaData getMetaData() throws SQLException;

    public CommonJ1ResultSet(BaseStatement baseStatement, int n, Field[] fieldArray, Vector vector, String string, int n2, long l, boolean bl) {
        this.connection = baseStatement.getFMConnection();
        this.statement = baseStatement;
        this.commandID = n;
        this.fields = fieldArray;
        this.rows = vector;
        this.status = string;
        this.updateCount = n2;
        this.hasFetched = vector != null;
        this.insertType = l;
        this.this_row = null;
        this.current_row = -1;
        this.binaryCursor = bl;
        this.totalRowsFetched = 0;
        try {
            this.resultSetType = baseStatement.getResultSetType();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.fetchSize = baseStatement == null ? 0 : baseStatement.getFetchSize();
        this.lastFetchSize = this.fetchSize;
    }

    public CommonJ1ResultSet(BaseStatement baseStatement, Field[] fieldArray, Vector vector, int n, int n2, int n3, int n4) throws SQLException {
        this.connection = baseStatement.getFMConnection();
        this.statement = baseStatement;
        this.fields = fieldArray;
        this.rows = vector;
        this.resultSetType = n3;
        this.totalRowsFetched = 0;
        this.hasFetched = vector != null;
    }

    @Override
    public BaseStatement getFMStatement() {
        return this.statement;
    }

    @Override
    public StringBuffer getStringBuffer() {
        return this.sbuf;
    }

    @Override
    public int getCommandID() {
        return this.commandID;
    }

    @Override
    public void setStatement(BaseStatement baseStatement) {
    }

    @Override
    public void reInit(Vector vector, String string, int n, long l, boolean bl) {
        this.rows = vector;
        this.status = string;
        this.updateCount = n;
        this.insertType = l;
        this.this_row = null;
        this.current_row = -1;
        this.binaryCursor = bl;
        this.hasFetched = true;
    }

    @Override
    public void resetFetchedStatus() {
        this.hasFetched = false;
    }

    @Override
    public void setResultCount(int n) {
        this.updateCount = n;
    }

    public void setFetchSize(int n) throws SQLException {
        this.fetchSize = n;
    }

    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean next() throws SQLException {
        block18: {
            if (Driver.logInfo) {
                Driver.info("rs.next();");
            }
            if (!this.hasFetched) {
                if (this.resultSetType == 1003) {
                    FM_API.next(this);
                } else {
                    FM_API.getAllResults(this);
                }
            }
            if (this.rows == null) {
                throw new FMSQLException("Cursor has been closed.", "HY000", 27090);
            }
            if (this.statement.getMaxRows() > 0 && this.totalRowsFetched >= this.statement.getMaxRows()) {
                this.this_row = null;
                this.current_row = this.rows.size();
                return false;
            }
            if (this.current_row + 1 >= this.rows.size()) {
                String string = this.statement.getFetchingCursorName();
                if (string == null) {
                    if (this.resultSetType == 1003 && this.commandID != -1) {
                        if (Driver.logInfo) {
                            Driver.info("rs.next(): getting next batch of rows");
                        }
                        FM_API.next(this);
                        this.lastFetchSize = this.rows.size();
                        this.current_row = 0;
                        if (this.rows.size() == 0) {
                            return false;
                        }
                        break block18;
                    } else {
                        this.current_row = this.rows.size();
                        return false;
                    }
                }
                String[] stringArray = new String[]{this.fetchSize == 0 ? "FETCH next FROM " + string : "FETCH next FROM " + string};
                FM_API.execDirect(stringArray, new String[0], this);
                this.lastFetchSize = this.fetchSize;
                this.commandID = this.statement.getCommandID();
                FM_API.getAllResults(this);
                if (this.rows.size() == 0) {
                    return false;
                }
                this.current_row = 0;
            } else {
                ++this.current_row;
            }
        }
        ++this.totalRowsFetched;
        this.this_row = (FMColumnValue[])this.rows.elementAt(this.current_row);
        this.rowBuffer = new byte[this.this_row.length][];
        int n = 0;
        for (n = 0; n < this.this_row.length; ++n) {
            if (this.this_row[n].isVector) continue;
            this.rowBuffer[n] = this.this_row[n].byteValue;
        }
        this.savedRow = new byte[this.this_row.length][];
        n = 0;
        while (n < this.this_row.length) {
            if (!this.this_row[n].isVector) {
                this.savedRow[n] = this.this_row[n].byteValue;
            }
            ++n;
        }
        return true;
    }

    @Override
    public void close() throws SQLException {
        if (Driver.logInfo) {
            Driver.info("rs.close();");
        }
        if (this.rows != null) {
            this.rows = null;
            if (this.statement != null) {
                int n = this.statement.getCommandID();
                boolean bl = true;
                if (this.statement.getIsPrepared()) {
                    bl = false;
                }
                if (n != -1) {
                    FM_API.closeCursor(n, bl, this.statement);
                }
            }
        }
    }

    public boolean wasNull() throws SQLException {
        if (Driver.logInfo) {
            Driver.info("rs.wasNull();");
        }
        return this.wasNullFlag;
    }

    @Override
    public String getString(int n) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("rs.getString(" + n + ");");
        }
        this.checkResultSet(n);
        boolean bl = this.wasNullFlag = this.this_row[n - 1].isNull == 1;
        if (this.wasNullFlag) {
            return null;
        }
        Encoding encoding = this.connection.getEncoding();
        return this.trimString(n, encoding.decode(this.this_row[n - 1].getValue()));
    }

    public boolean getBoolean(int n) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("rs.getBoolean(" + n + ");");
        }
        boolean bl = false;
        try {
            bl = CommonJ1ResultSet.toBoolean(this.getString(n));
        }
        catch (SQLException sQLException) {
            throw new FMSQLException("Invalid value for getBoolean(): '" + this.getString(n) + "'", 27300);
        }
        return bl;
    }

    public byte getByte(int n) throws SQLException {
        String string;
        if (Driver.logInfo) {
            Driver.info("rs.getByte(" + n + ");");
        }
        if ((string = this.getString(n)) != null) {
            try {
                switch (this.fields[n - 1].getSQLType()) {
                    case 2: 
                    case 3: 
                    case 6: 
                    case 7: 
                    case 8: {
                        int n2 = string.indexOf(".");
                        if (n2 == -1 || Integer.parseInt(string.substring(n2 + 1, string.length())) != 0) break;
                        string = string.substring(0, n2);
                        break;
                    }
                    case 1: {
                        string = string.trim();
                    }
                }
                return Byte.parseByte(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new FMSQLException("Invalid value for getByte(): '" + string + "'", 27301);
            }
        }
        return 0;
    }

    public short getShort(int n) throws SQLException {
        String string;
        if (Driver.logInfo) {
            Driver.info("rs.getShort(" + n + ");");
        }
        if ((string = this.getString(n)) != null) {
            try {
                switch (this.fields[n - 1].getSQLType()) {
                    case 2: 
                    case 3: 
                    case 6: 
                    case 7: 
                    case 8: {
                        int n2 = string.indexOf(".");
                        if (n2 == -1 || Integer.parseInt(string.substring(n2 + 1, string.length())) != 0) break;
                        string = string.substring(0, n2);
                        break;
                    }
                    case 1: {
                        string = string.trim();
                    }
                }
                return Short.parseShort(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new FMSQLException("Invalid value for getShort(): '" + string + "'", 27302);
            }
        }
        return 0;
    }

    public int getInt(int n) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("rs.getInt(" + n + ");");
        }
        int n2 = 0;
        try {
            n2 = CommonJ1ResultSet.toInt(this.getString(n));
        }
        catch (SQLException sQLException) {
            throw new FMSQLException("Invalid value for getInt(): '" + this.getString(n) + "'", 27303);
        }
        return n2;
    }

    public long getLong(int n) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("rs.getLong(" + n + ");");
        }
        long l = 0L;
        try {
            l = CommonJ1ResultSet.toLong(this.getString(n));
        }
        catch (SQLException sQLException) {
            throw new FMSQLException("Invalid value for getLong(): '" + this.getString(n) + "'", 27304);
        }
        return l;
    }

    public float getFloat(int n) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("rs.getFloat(" + n + ");");
        }
        float f = 0.0f;
        try {
            f = CommonJ1ResultSet.toFloat(this.getString(n));
        }
        catch (SQLException sQLException) {
            throw new FMSQLException("Invalid value for getFloat(): '" + this.getString(n) + "'", 27305);
        }
        return f;
    }

    public double getDouble(int n) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("rs.getDouble(" + n + ");");
        }
        double d = 0.0;
        try {
            d = CommonJ1ResultSet.toDouble(this.getString(n));
        }
        catch (SQLException sQLException) {
            throw new FMSQLException("Invalid value for getDouble(): '" + this.getString(n) + "'", 27306);
        }
        return d;
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        BigDecimal bigDecimal;
        if (Driver.logInfo) {
            Driver.info("rs.getDouble(" + n + ", " + n2 + ");");
        }
        try {
            bigDecimal = CommonJ1ResultSet.toBigDecimal(this.getString(n), n2);
        }
        catch (SQLException sQLException) {
            throw new FMSQLException("Invalid value for getBigDecimal(): '" + this.getString(n) + "'", 27307);
        }
        return bigDecimal;
    }

    public byte[] getBytes(int n) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("rs.getBytes(" + n + ");");
        }
        this.checkResultSet(n);
        boolean bl = this.wasNullFlag = this.this_row[n - 1].isNull == 1;
        if (!this.wasNullFlag) {
            if (this.binaryCursor) {
                return this.this_row[n - 1].getValue();
            }
            return this.trimBytes(n, this.this_row[n - 1].getValue());
        }
        return null;
    }

    public Date getDate(int n) throws SQLException {
        Date date;
        if (Driver.logInfo) {
            Driver.info("rs.getDate(" + n + ");");
        }
        try {
            date = CommonJ1ResultSet.toDate(this.getString(n));
        }
        catch (SQLException sQLException) {
            throw new FMSQLException("Invalid value for getDate(): '" + this.getString(n) + "'", 27308);
        }
        return date;
    }

    public Time getTime(int n) throws SQLException {
        Time time;
        if (Driver.logInfo) {
            Driver.info("rs.getTime(" + n + ");");
        }
        try {
            time = CommonJ1ResultSet.toTime(this.getString(n), this, this.fields[n - 1].getFMType());
        }
        catch (SQLException sQLException) {
            throw new FMSQLException("Invalid value for getTime(): '" + this.getString(n) + "'", 27309);
        }
        return time;
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        Timestamp timestamp;
        if (Driver.logInfo) {
            Driver.info("rs.getTimestamp(" + n + ");");
        }
        try {
            timestamp = CommonJ1ResultSet.toTimestamp(this.getString(n), this, this.fields[n - 1].getFMType());
        }
        catch (SQLException sQLException) {
            throw new FMSQLException("Invalid value for getTimestamp(): '" + this.getString(n) + "'", 27310);
        }
        return timestamp;
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("rs.getAsciiStream(" + n + ");");
        }
        this.checkResultSet(n);
        boolean bl = this.wasNullFlag = this.this_row[n - 1].isNull == 1;
        if (this.wasNullFlag) {
            return null;
        }
        return this.getBinaryStream(n);
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("rs.getUnicodeStream(" + n + ");");
        }
        this.checkResultSet(n);
        boolean bl = this.wasNullFlag = this.this_row[n - 1].isNull == 1;
        if (this.wasNullFlag) {
            return null;
        }
        return this.getBinaryStream(n);
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("rs.getBinaryStream(" + n + ");");
        }
        this.checkResultSet(n);
        boolean bl = this.wasNullFlag = this.this_row[n - 1].isNull == 1;
        if (this.wasNullFlag) {
            return null;
        }
        return new FMInputStream(this.this_row[n - 1]);
    }

    public String getString(String string) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("rs.getString(" + string + ");");
        }
        return this.getString(this.findColumn(string));
    }

    public boolean getBoolean(String string) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("rs.getBoolean(" + string + ");");
        }
        return this.getBoolean(this.findColumn(string));
    }

    public byte getByte(String string) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("rs.getByte(" + string + ");");
        }
        return this.getByte(this.findColumn(string));
    }

    public short getShort(String string) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("rs.getShort(" + string + ");");
        }
        return this.getShort(this.findColumn(string));
    }

    public int getInt(String string) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("rs.getInt(" + string + ");");
        }
        return this.getInt(this.findColumn(string));
    }

    public long getLong(String string) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("rs.getLong(" + string + ");");
        }
        return this.getLong(this.findColumn(string));
    }

    public float getFloat(String string) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("rs.getFloat(" + string + ");");
        }
        return this.getFloat(this.findColumn(string));
    }

    public double getDouble(String string) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("rs.getDouble(" + string + ");");
        }
        return this.getDouble(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("rs.getBigDecimal(" + string + ");");
        }
        return this.getBigDecimal(this.findColumn(string), n);
    }

    public byte[] getBytes(String string) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("rs.getBytes(" + string + ");");
        }
        return this.getBytes(this.findColumn(string));
    }

    public Date getDate(String string) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("rs.getDate(" + string + ");");
        }
        return this.getDate(this.findColumn(string));
    }

    public Time getTime(String string) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("rs.getTime(" + string + ");");
        }
        return this.getTime(this.findColumn(string));
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("rs.getTimestamp(" + string + ");");
        }
        return this.getTimestamp(this.findColumn(string));
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("rs.getAsciiStream(" + string + ");");
        }
        return this.getAsciiStream(this.findColumn(string));
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("rs.getUnicodeStream(" + string + ");");
        }
        return this.getUnicodeStream(this.findColumn(string));
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("rs.getBinaryStream(" + string + ");");
        }
        return this.getBinaryStream(this.findColumn(string));
    }

    public SQLWarning getWarnings() throws SQLException {
        if (Driver.logInfo) {
            Driver.info("rs.getWarnings();");
        }
        return this.warnings;
    }

    public void clearWarnings() throws SQLException {
        if (Driver.logInfo) {
            Driver.info("rs.clearWarnings();");
        }
        this.warnings = null;
    }

    public void addWarnings(SQLWarning sQLWarning) {
        if (this.warnings != null) {
            this.warnings.setNextWarning(sQLWarning);
        } else {
            this.warnings = sQLWarning;
        }
    }

    @Override
    public String getCursorName() throws SQLException {
        if (Driver.logInfo) {
            Driver.info("rs.getCursorName();");
        }
        return this.connection.getCursorName();
    }

    @Override
    public Object getObject(int n) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("rs.getObject(" + n + ");");
        }
        if (n < 1 || n > this.fields.length) {
            throw new FMSQLException("The column index is out of range.", "07006", 27094);
        }
        Field field = this.fields[n - 1];
        if (field == null) {
            this.wasNullFlag = true;
            return null;
        }
        switch (field.getSQLType()) {
            case -7: {
                return this.getBoolean(n) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 5: {
                return new Short(this.getShort(n));
            }
            case 4: {
                return new Integer(this.getInt(n));
            }
            case -5: {
                return new Long(this.getLong(n));
            }
            case 2: {
                return this.getBigDecimal(n, field.getMod() == -1 ? -1 : field.getMod() - 4 & 0xFFFF);
            }
            case 7: {
                return new Float(this.getFloat(n));
            }
            case 8: {
                return new Double(this.getDouble(n));
            }
            case 1: 
            case 12: {
                return this.getString(n);
            }
            case 91: {
                return this.getDate(n);
            }
            case 92: {
                return this.getTime(n);
            }
            case 93: {
                return this.getTimestamp(n);
            }
            case -3: 
            case -2: {
                return this.getBytes(n);
            }
        }
        String string = field.getFMType();
        return this.getString(n);
    }

    public Object getObject(String string) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("rs.getObject(" + string + ");");
        }
        return this.getObject(this.findColumn(string));
    }

    public int findColumn(String string) throws SQLException {
        int n = this.fields.length;
        for (int i = 0; i < n; ++i) {
            if (!this.fields[i].getName().equalsIgnoreCase(string)) continue;
            return i + 1;
        }
        throw new FMSQLException("Column name not found: " + string, 27095);
    }

    @Override
    public boolean reallyResultSet() {
        return this.fields != null;
    }

    @Override
    public ResultSet getNext() {
        return (ResultSet)((Object)this.next);
    }

    @Override
    public void append(BaseResultSet baseResultSet) {
        if (this.next == null) {
            this.next = baseResultSet;
        } else {
            this.next.append(baseResultSet);
        }
    }

    @Override
    public int getResultCount() {
        return this.updateCount;
    }

    @Override
    public int getTupleCount() {
        return this.rows.size();
    }

    @Override
    public int getColumnCount() {
        return this.fields.length;
    }

    @Override
    public String getStatusString() {
        return this.status;
    }

    public int getColumnType(int n) {
        return this.fields[n - 1].getType();
    }

    public int getInsertedType() {
        return (int)this.getLastType();
    }

    @Override
    public long getLastType() {
        return this.insertType;
    }

    protected void checkResultSet(int n) throws SQLException {
        if (this.rows == null) {
            throw new FMSQLException("Cursor has been closed.", 27096);
        }
        if (this.this_row == null) {
            throw new FMSQLException("Cursor is not positioned.", 27097);
        }
        if (n < 1 || n > this.fields.length) {
            throw new FMSQLException("The column index is out of range.", "22023", 27098);
        }
    }

    public static boolean toBoolean(String string) {
        if (string != null) {
            if ((string = string.trim()).equalsIgnoreCase("true") || string.equalsIgnoreCase("t")) {
                return true;
            }
            try {
                if (Double.valueOf(string) == 1.0) {
                    return true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    public static int toInt(String string) throws SQLException {
        if (string != null) {
            try {
                string = string.trim();
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new FMSQLException(numberFormatException.getMessage() + ": " + string, "22003", 27099);
            }
        }
        return 0;
    }

    public static long toLong(String string) throws SQLException {
        if (string != null) {
            try {
                string = string.trim();
                return Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new FMSQLException(numberFormatException.getMessage() + ": " + string, "22003", 27100);
            }
        }
        return 0L;
    }

    public static BigDecimal toBigDecimal(String string, int n) throws SQLException {
        if (string != null) {
            BigDecimal bigDecimal;
            try {
                string = string.trim();
                bigDecimal = new BigDecimal(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new FMSQLException(numberFormatException.getMessage() + ": " + string, "22003", 27101);
            }
            if (n == -1) {
                return bigDecimal;
            }
            try {
                return bigDecimal.setScale(n);
            }
            catch (ArithmeticException arithmeticException) {
                throw new FMSQLException(arithmeticException.getMessage() + ": " + string, "22003", 27102);
            }
        }
        return null;
    }

    public static float toFloat(String string) throws SQLException {
        if (string != null) {
            try {
                string = string.trim();
                return Float.valueOf(string).floatValue();
            }
            catch (NumberFormatException numberFormatException) {
                throw new FMSQLException(numberFormatException.getMessage() + ": " + string, "22003", 27103);
            }
        }
        return 0.0f;
    }

    public static double toDouble(String string) throws SQLException {
        if (string != null) {
            try {
                string = string.trim();
                return Double.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new FMSQLException(numberFormatException.getMessage() + ": " + string, "22003", 27104);
            }
        }
        return 0.0;
    }

    public static Date toDate(String string) throws SQLException {
        if (string == null) {
            return null;
        }
        try {
            string = string.trim();
            if (string.length() >= 10) {
                return Date.valueOf(string.length() == 10 ? string : string.substring(0, 10));
            }
            throw new FMSQLException("Invalid value for toDate(): '" + string + "'", 27105);
        }
        catch (NumberFormatException numberFormatException) {
            throw new FMSQLException(numberFormatException.getMessage() + ": " + string, "22003", 27105);
        }
    }

    public static Time toTime(String string, BaseResultSet baseResultSet, String string2) throws SQLException {
        if (string == null) {
            return null;
        }
        try {
            string = string.trim();
            if (string.length() == 8) {
                return Time.valueOf(string);
            }
            if (string.indexOf(".") == 8) {
                int n;
                Time time = Time.valueOf(string.substring(0, 8));
                String string3 = string.substring(9);
                if (string3.length() > 3) {
                    string3 = string3.substring(0, 3);
                }
                if ((n = Integer.parseInt(string3)) < 10) {
                    n *= 100;
                } else if (n < 100) {
                    n *= 10;
                }
                return new Time(time.getTime() + (long)n);
            }
            return new Time(CommonJ1ResultSet.toTimestamp(string, baseResultSet, string2).getTime());
        }
        catch (NumberFormatException numberFormatException) {
            throw new FMSQLException(numberFormatException.getMessage() + ": " + string, "22003", 27106);
        }
    }

    public static Timestamp toTimestamp(String string, BaseResultSet baseResultSet, String string2) throws SQLException {
        BaseResultSet baseResultSet2 = baseResultSet;
        if (string == null) {
            return null;
        }
        string = string.trim();
        BaseResultSet baseResultSet3 = baseResultSet2;
        synchronized (baseResultSet3) {
            StringBuffer stringBuffer = baseResultSet2.getStringBuffer();
            SimpleDateFormat simpleDateFormat = null;
            if (Driver.logDebug) {
                Driver.debug("the data from the DB is " + string);
            }
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer(32);
            } else {
                stringBuffer.setLength(0);
            }
            stringBuffer.append(string);
            int n = string.length();
            int n2 = 0;
            if (n > 19) {
                int n3 = 19;
                stringBuffer.setLength(n3);
                char c = string.charAt(n3++);
                if (c == '.') {
                    int n4 = n3;
                    while (Character.isDigit(c = string.charAt(n3++))) {
                        if (n3 != n) continue;
                        ++n3;
                        break;
                    }
                    int n5 = n3 - 1;
                    try {
                        n2 = Integer.parseInt(string.substring(n4, n5));
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new FMSQLException(numberFormatException.getMessage(), 27160);
                    }
                    for (int i = 9 - (n5 - n4); i > 0; --i) {
                        n2 *= 10;
                    }
                }
                if (n3 < n) {
                    stringBuffer.append(" GMT");
                    stringBuffer.append(c);
                    stringBuffer.append(string.substring(n3, n));
                    if (n - n3 < 5) {
                        stringBuffer.append(":00");
                    }
                    simpleDateFormat = baseResultSet2.getTimestampTZFormat();
                } else if (string2.equals("timestamptz")) {
                    stringBuffer.append(" GMT");
                    simpleDateFormat = baseResultSet2.getTimestampTZFormat();
                } else {
                    simpleDateFormat = baseResultSet2.getTimestampFormat();
                }
            } else if (n == 19) {
                if (string2.equals("timestamptz")) {
                    stringBuffer.append(" GMT");
                    simpleDateFormat = baseResultSet2.getTimestampTZFormat();
                } else {
                    simpleDateFormat = baseResultSet2.getTimestampFormat();
                }
            } else {
                if (n == 8 && string.equals("infinity")) {
                    string = "9999-01-01";
                }
                if (n == 9 && string.equals("-infinity")) {
                    string = "0001-01-01";
                }
                simpleDateFormat = baseResultSet2.getDateFormat();
            }
            try {
                if (Driver.logDebug) {
                    Driver.debug("the data after parsing is " + stringBuffer.toString() + " with " + n2 + " nanos");
                }
                Timestamp timestamp = new Timestamp(simpleDateFormat.parse(stringBuffer.toString()).getTime());
                timestamp.setNanos(n2);
                return timestamp;
            }
            catch (ParseException parseException) {
                throw new FMSQLException("Timestamp format error: " + string, "22007", 27107);
            }
        }
    }

    private boolean isColumnTrimmable(int n) throws SQLException {
        switch (this.fields[n - 1].getSQLType()) {
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    private byte[] trimBytes(int n, byte[] byArray) throws SQLException {
        int n2 = this.statement.getMaxFieldSize();
        if (n2 > 0 && byArray.length > n2 && this.isColumnTrimmable(n)) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            return byArray2;
        }
        return byArray;
    }

    private String trimString(int n, String string) throws SQLException {
        int n2 = this.statement.getMaxFieldSize();
        if (n2 > 0 && string.length() > n2 && this.isColumnTrimmable(n)) {
            return string.substring(0, n2);
        }
        return string;
    }

    @Override
    public SimpleDateFormat getTimestampTZFormat() {
        if (this.m_tstzFormat == null) {
            this.m_tstzFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
        }
        return this.m_tstzFormat;
    }

    @Override
    public SimpleDateFormat getTimestampFormat() {
        if (this.m_tsFormat == null) {
            this.m_tsFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
        return this.m_tsFormat;
    }

    @Override
    public SimpleDateFormat getDateFormat() {
        if (this.m_dateFormat == null) {
            this.m_dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        }
        return this.m_dateFormat;
    }
}

