/*
 * Decompiled with CFR 0.152.
 */
package com.filemaker.jdbc2.optional;

import com.filemaker.jdbc.Driver;
import com.filemaker.jdbc.FMSQLException;
import com.filemaker.jdbc2.optional.BaseDataSource;
import com.filemaker.jdbc2.optional.ConnectionPool;
import com.filemaker.jdbc2.optional.PooledConnectionImpl;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.DataSource;
import javax.sql.PooledConnection;

public class PoolingDataSource
extends BaseDataSource
implements DataSource {
    private static Map dataSources = new HashMap();
    protected String dataSourceName;
    private int initialConnections = 0;
    private int maxConnections = 0;
    private boolean initialized = false;
    private Stack available = new Stack();
    private Stack used = new Stack();
    private Object lock = new Object();
    private ConnectionPool source;
    private ConnectionEventListener connectionEventListener = new ConnectionEventListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void connectionClosed(ConnectionEvent connectionEvent) {
            ((PooledConnection)connectionEvent.getSource()).removeConnectionEventListener(this);
            Object object = PoolingDataSource.this.lock;
            synchronized (object) {
                if (PoolingDataSource.this.available == null) {
                    return;
                }
                boolean bl = PoolingDataSource.this.used.remove(connectionEvent.getSource());
                if (bl) {
                    PoolingDataSource.this.available.push(connectionEvent.getSource());
                    PoolingDataSource.this.lock.notify();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
            ((PooledConnection)connectionEvent.getSource()).removeConnectionEventListener(this);
            Object object = PoolingDataSource.this.lock;
            synchronized (object) {
                if (PoolingDataSource.this.available == null) {
                    return;
                }
                PoolingDataSource.this.used.remove(connectionEvent.getSource());
                PoolingDataSource.this.lock.notify();
            }
        }
    };

    static PoolingDataSource getDataSource(String string) {
        return (PoolingDataSource)dataSources.get(string);
    }

    @Override
    public String getDescription() {
        return "Pooling DataSource '" + this.dataSourceName + " from " + Driver.getVersion();
    }

    @Override
    public void setServerName(String string) {
        if (this.initialized) {
            throw new IllegalStateException("Cannot set Data Source properties after DataSource has been used");
        }
        super.setServerName(string);
    }

    @Override
    public void setDatabaseName(String string) {
        if (this.initialized) {
            throw new IllegalStateException("Cannot set Data Source properties after DataSource has been used");
        }
        super.setDatabaseName(string);
    }

    @Override
    public void setUser(String string) {
        if (this.initialized) {
            throw new IllegalStateException("Cannot set Data Source properties after DataSource has been used");
        }
        super.setUser(string);
    }

    @Override
    public void setPassword(String string) {
        if (this.initialized) {
            throw new IllegalStateException("Cannot set Data Source properties after DataSource has been used");
        }
        super.setPassword(string);
    }

    @Override
    public void setPortNumber(int n) {
        if (this.initialized) {
            throw new IllegalStateException("Cannot set Data Source properties after DataSource has been used");
        }
        super.setPortNumber(n);
    }

    public int getInitialConnections() {
        return this.initialConnections;
    }

    public void setInitialConnections(int n) {
        if (this.initialized) {
            throw new IllegalStateException("Cannot set Data Source properties after DataSource has been used");
        }
        this.initialConnections = n;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int n) {
        if (this.initialized) {
            throw new IllegalStateException("Cannot set Data Source properties after DataSource has been used");
        }
        this.maxConnections = n;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataSourceName(String string) {
        if (this.initialized) {
            throw new IllegalStateException("Cannot set Data Source properties after DataSource has been used");
        }
        if (this.dataSourceName != null && string != null && string.equals(this.dataSourceName)) {
            return;
        }
        Map map = dataSources;
        synchronized (map) {
            if (PoolingDataSource.getDataSource(string) != null) {
                throw new IllegalArgumentException("DataSource with name '" + string + "' already exists!");
            }
            if (this.dataSourceName != null) {
                dataSources.remove(this.dataSourceName);
            }
            this.dataSourceName = string;
            dataSources.put(string, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            this.source = this.createConnectionPool();
            this.source.setDatabaseName(this.getDatabaseName());
            this.source.setPassword(this.getPassword());
            this.source.setPortNumber(this.getPortNumber());
            this.source.setServerName(this.getServerName());
            this.source.setUser(this.getUser());
            while (this.available.size() < this.initialConnections) {
                this.available.push(this.source.getPooledConnection());
            }
            this.initialized = true;
        }
    }

    protected boolean isInitialized() {
        return this.initialized;
    }

    protected ConnectionPool createConnectionPool() {
        return new ConnectionPool();
    }

    @Override
    public Connection getConnection(String string, String string2) throws SQLException {
        if (string == null || string.equals(this.getUser()) && (string2 == null && this.getPassword() == null || string2 != null && string2.equals(this.getPassword()))) {
            return this.getConnection();
        }
        if (!this.initialized) {
            this.initialize();
        }
        return super.getConnection(string, string2);
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (!this.initialized) {
            this.initialize();
        }
        return this.getPooledConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            PooledConnectionImpl pooledConnectionImpl;
            while (this.available.size() > 0) {
                pooledConnectionImpl = (PooledConnectionImpl)this.available.pop();
                try {
                    pooledConnectionImpl.close();
                }
                catch (SQLException sQLException) {}
            }
            this.available = null;
            while (true) {
                if (this.used.size() <= 0) {
                    this.used = null;
                    // MONITOREXIT @DISABLED, blocks:[3, 7, 8] lbl14 : MonitorExitStatement: MONITOREXIT : var1_1
                    this.removeStoredDataSource();
                    return;
                }
                pooledConnectionImpl = (PooledConnectionImpl)this.used.pop();
                pooledConnectionImpl.removeConnectionEventListener(this.connectionEventListener);
                try {
                    pooledConnectionImpl.close();
                }
                catch (SQLException sQLException) {
                }
            }
        }
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeStoredDataSource() {
        Map map = dataSources;
        synchronized (map) {
            dataSources.remove(this.dataSourceName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getPooledConnection() throws SQLException {
        PooledConnection pooledConnection = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.available == null) {
                throw new FMSQLException("DataSource has been closed.", 27224);
            }
            while (true) {
                if (this.available.size() > 0) {
                    pooledConnection = (PooledConnection)this.available.pop();
                    this.used.push(pooledConnection);
                    break;
                }
                if (this.maxConnections == 0 || this.used.size() < this.maxConnections) {
                    pooledConnection = this.source.getPooledConnection();
                    this.used.push(pooledConnection);
                    break;
                }
                try {
                    this.lock.wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        pooledConnection.addConnectionEventListener(this.connectionEventListener);
        return pooledConnection.getConnection();
    }

    @Override
    public Reference getReference() throws NamingException {
        Reference reference = super.getReference();
        reference.add(new StringRefAddr("dataSourceName", this.dataSourceName));
        if (this.initialConnections > 0) {
            reference.add(new StringRefAddr("initialConnections", Integer.toString(this.initialConnections)));
        }
        if (this.maxConnections > 0) {
            reference.add(new StringRefAddr("maxConnections", Integer.toString(this.maxConnections)));
        }
        return reference;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }
}

